<?php
namespace addons\yccms\taglib;

use fast\Random;
use think\Exception;
use think\Log;
use think\template\TagLib;

/**
 * yccms 自定义标签
 */
class Yc extends TagLib
{
    /**
     * 定义标签列表
     */
    protected $tags   =  [
        // 标签定义： attr 属性列表 close 是否闭合（0 或者1 默认1） alias 标签别名 level 嵌套层次
        'banners'     => ['attr' => 'id,key,type,group_id,banner_ids', 'close' => 1], //闭合标签，默认为不闭合
        'category'     => ['attr' => 'id,key,pid,is_cate_stu', 'close' => 1,'alias'=>'cate','expression'=>true],
        'c_info' => ['attr' => 'cid,name', 'close' => 0],
        'single' => ['attr' => 'cid,name', 'close' => 0],
        'config'     => ['attr' => 'name,is_http', 'close' => 0],
        'config_arr'     => ['attr' => 'name,id,key,is_http', 'close' => 1],
        'article'     => ['attr' => 'id,key,name,empty,category_id,son,rows,orderby,orderway,cache,is_field,field,no_field,is_page,limit', 'close' => 1], //闭合标签，默认为不闭合
        'article_page' => ['attr' => 'condition,name', 'close' => 0],
        'details' => ['attr' => 'id,cid,name,time,is_domain,is_annotation', 'close' => 0],
        'details_var' => ['attr' => 'id,cid,name,time,is_domain,is_annotation', 'close' => 0],
        'details_arr' => ['attr' => 'id,cid,name,time,is_domain,is_annotation', 'close' => 1],
    ];

    /**
     * 输出详情变量
     * @param $tag['site'] 配置项调用名
     * @return void
     */
    public function tagDetails_var($tag):string
    {
        $parse = \addons\yccms\library\tag\TagControls::getTagDetails($tag);
        $res_str = $parse[0]??$tag['empty'];
        $parse = '<?php ';
        $parse .= '$' . $tag['name'] . ' = "'.$res_str.'";';
        $parse .= ' ?>';
        return $parse;
    }

     /**
      * 获取详情
      * @param $tag['site'] 配置项调用名
      * @return void
      */
    public function tagDetails($tag):string
    {
        $tag['empty'] = $tag['empty']??'';
        //获取参数
        $params = [];
        foreach ($tag as $k => &$v) {
            $origin = $v;
            if (in_array($k, ['id','cid'])) {
                $this->autoBuildVar($v);
            }
            $v = $origin == $v ? '"' . $v . '"' : $v;
            $params[] = '"' . $k . '"=>' . $v;
        }
        $var = Random::alnum(10);
        $parse = '<?php ';
        $parse .= '$__' . $var . '__ = \addons\yccms\library\tag\TagControls::getTagDetails(['. implode(',', $params).']);';
        $parse .= '$__' . $var . '__ = $__' . $var . '__[0]??'.$tag['empty'].';';
        $parse .= 'echo $__' . $var . '__;';
        $parse .= ' ?>';
        return $parse;
    }

    /**
     * 获取配置项 数组类型
     * @param $tag['separator'] 分割符
     * @return void
     */
    public function tagDetails_arr($tag,$content):string
    {
        $tag['is_arr'] = 1;
        $tag['separator'] = $tag['separator']??',';
        //获取参数
        $params = [];
        foreach ($tag as $k => &$v) {
            $origin = $v;
            if (in_array($k, ['id','cid'])) {
                $this->autoBuildVar($v);
            }
            $v = $origin == $v ? '"' . $v . '"' : $v;
            $params[] = '"' . $k . '"=>' . $v;
        }
        $var = Random::alnum(10);
        $parse = '<?php ';
        $parse .= '$__' . $var . '__ = \addons\yccms\library\tag\TagControls::getTagDetails(['. implode(',', $params).']);';
        $parse .= '$__' . $var . '__ = empty($__' . $var . '__)?[]:$__' . $var . '__;';
        $parse .= ' ?>';
        $parse .= '{volist name="$__' . $var . '__" id="item" key="key"}';
        $parse .= $content;
        $parse .= '{/volist}';
        return $parse;
    }

    /**
     * 获取列表数据
     * @param $tag
     * @param $content
     * @return void
     */
    public function tagArticle($tag, $content){
        $cid = input('param.cid');
        if (empty($tag['category_id']) && !empty($cid))$tag['category_id'] = $cid;
        $tag['id'] = $tag['id'] ?? 'item';//列表循环变量
        $tag['key'] = $tag['key'] ?? 'key';//循环key
        $tag['empty'] = $tag['empty'] ?? '';//数据为空值
        $tag['name'] = $tag['name'] ?? 'yc_arcList';//数据变量名
        $tag['son'] = $tag['son'] ?? 1;//数据类型 1 = 当前栏目数据（默认） 2 = 当前栏目和子栏目数据
        $tag['rows'] = $tag['rows'] ?? 8;//分页数量
        $tag['limit'] = $tag['limit'] ?? 8;//偏移值
        $tag['orderby'] = $tag['orderby'] ?? 'id';//排序字段
        $tag['orderway'] = $tag['orderway'] ?? 'desc';//排序方式
        $tag['date'] = $tag['date'] ?? 'Y-m-d H:i:s';//时间格式化
        $tag['cache'] = $tag['cache'] ?? 0;//缓存查询
        $tag['is_field'] = $tag['is_field'] ?? 0;//字段选项 0 = 无操作 1 = 查询字段 2 = 隐藏字段
        $tag['field'] = $tag['field'] ?? '*';//查询字段
        $tag['no_field'] = $tag['no_field'] ?? '';//隐藏字段
        $tag['is_easy'] = $tag['is_easy'] ?? false;//简单分页 0 = false（默认）1 = true
        $tag['is_page'] = $tag['is_page'] ?? 1;//是否为分页 1 = 分页数据 2 = 列表数据
        //判断栏目id不能为空
        if (empty($tag['category_id']))throw new Exception('栏目id不存在');
        if (empty($tag['name']))throw new Exception('Article标签 必须填写name');
        //获取参数
        $params = [];
        foreach ($tag as $k => &$v) {
            $origin = $v;
            if (in_array($k, ['category_id', 'rows', 'cache', 'empty'])) {
                $this->autoBuildVar($v);
            }
            $v = $origin == $v ? '"' . $v . '"' : $v;
            $params[] = '"' . $k . '"=>' . $v;
        }
        //变量名
        $name = ltrim(rtrim($tag['name'],'"'),'"');
        $var = Random::alnum(10);
        $parse = '<?php ';
        $parse .= '$__' . $var . '__ = \addons\yccms\library\tag\TagControls::getPageData(['. implode(',', $params).']);';
        $parse .= ' ?>';
        $parse .= '{volist name="$__' . $var . '__" id=' . $tag['id'] . ' key=' . $tag['key'] . ' empty=' . $tag['empty'] . '}';
        $parse .= $content;
        $parse .= '{/volist}';
        $parse .= "{php}$$name" . '=$__' . $var . '__;{/php}';
        return $parse;
    }

    /**
     * 列表分页
     * @param $tag
     * @param $content
     * @return string
     */
    public function tagArticle_page($tag, $content)
    {
        $params = [];
        $name = $tag['name'] ?? 'yc_arcList';//数据变量名
        unset($tag['name']);
        foreach ($tag as $k => & $v) {
            $origin = $v;
            if (in_array($k, ['condition'])) {
                $this->autoBuildVar($v);
            }
            $v = $origin == $v ? '"' . $v . '"' : $v;
            $params[] = '"' . $k . '"=>' . $v;
        }
        $parse = '{if !empty($' . $name . ') && !is_array($' . $name . ')}';
        $parse .= '{$' . $name . '->render([' . implode(',', $params) . '])}';
        $parse .= '{/if}';
        return $parse;
    }

    /**
     * 获取banner图
     * @param $tag 参数
     * @param $content
     * @return string
     */
    public function tagBanners($tag, $content): string
    {
        $tag['id'] = $tag['id'] ?? 'item';//列表循环变量
        $tag['key'] = $tag['key'] ?? 'key';//循环key
        $tag['group_id'] = $tag['group_id'] ?? 0;//轮播图分组id
        $tag['banner_ids'] = $tag['banner_ids'] ?? '';//轮播图ids
        $params = [];
        foreach ($tag as $k => &$v) {
            $origin = $v;
            if (in_array($k, ['condition'])) {
                $this->autoBuildVar($v);
            }
            $v = $origin == $v ? '"' . $v . '"' : $v;
            $params[] = '"' . $k . '"=>' . $v;
        }
        $var = Random::alnum(10);
        $parse = '<?php ';
        $parse .= '$__' . $var . '__ = \addons\yccms\library\tag\TagControls::getTagBanners(['. implode(',', $params).']);';
        $parse .= ' ?>';
        $parse .= '{volist name="$__' . $var . '__" id=' . $tag['id'] . ' key=' . $tag['key'] . ' }';
        $parse .= $content;
        $parse .= '{/volist}';
        return $parse;
    }

    /**
     * 栏目标签
     * @param $tag 参数
     * @param $content
     * @return string
     */
    public function tagCategory($tag, $content)
    {
        $tag['id'] = $tag['id'] ?? 'item';//列表循环变量
        $tag['key'] = $tag['key'] ?? 'key';//循环key
        $tag['pid'] = $tag['pid'] ?? 0;//父级栏目id 0 等于全部
        $tag['is_cate_stu'] = $tag['is_cate_stu'] ?? 1;//数据为空值 1 = 顶部栏目 2 = 底部栏目
        $tag['is_cate_url'] = $tag['is_cate_url'] ?? 0;//显示子集url 0 = 否 1 = 是
        $tag['name'] = $tag['name'] ?? 'yc_cateList';//变量名 默认为 $yc_cateList
        $tag['is_footer_stu'] = $tag['is_footer_stu'] ?? 0;//底部栏目格式化 仅底部栏目使用
        //0 = 无任何操作(默认)
        //1 = 不显示无子集的顶级栏目
        //2 = 所有无子集的栏目重组到第一位子集栏目的son字段中 首列
        //3 = 所有无子集的栏目重组到第一位子集栏目的son字段中 末列
        //获取参数
        $params = [];
        foreach ($tag as $k => &$v) {
            $origin = $v;
            if (in_array($k, ['pid', 'is_cate_stu', 'is_cate_url'])) {
                $this->autoBuildVar($v);
            }
            $v = $origin == $v ? '"' . $v . '"' : $v;
            $params[] = '"' . $k . '"=>' . $v;
        }
        $var = Random::alnum(10);
        $name = ltrim(rtrim($tag['name'],'"'),'"');
        $parse = '<?php ';
        $parse .= '$__' . $var . '__ = \addons\yccms\library\tag\TagControls::getTagCategory(['. implode(',', $params).']);';
        $parse .= ' ?>';
        $parse .= '{volist name="$__' . $var . '__" id=' . $tag['id'] . ' key=' . $tag['key'] . ' }';
        $parse .= $content;
        $parse .= '{/volist}';
        $parse .= "{php}$$name". '=$__' . $var . '__;{/php}';
        return $parse;

    }

    /**
     * 获取单个栏目的信息
     * @param $tag
     * @param $content
     * @return string
     */
    public function tagC_info($tag, $content): string
    {
        $params = [];
        $cid = input('param.cid');
        if (empty($tag['cid']))$tag['cid'] = $cid??0;
        $tag['name'] = $tag['name'] ?? 'id';//将要获取的栏目字段
        foreach ($tag as $k => & $v) {
            $origin = $v;
            if (in_array($k, ['cid'])) {
                $this->autoBuildVar($v);
            }
            $v = $origin == $v ? '"' . $v . '"' : $v;
            $params[] = '"' . $k . '"=>' . $v;
        }
        $parse = '<?php ';
        $parse .= 'echo \addons\yccms\library\tag\TagControls::getTagCategoryInfo(['. implode(',', $params).']);';
        $parse .= ' ?>';
        return $parse;
    }

    /**
     * 单页配置信息
     * @param $tag
     * @param $content
     * @return string
     */
    public function tagSingle($tag, $content): string
    {
        $params = [];
        if (empty($tag['single_id']))return '';
        if (empty($tag['name']))return '';
        foreach ($tag as $k => & $v) {
            $v = '"' . $v . '"';
            $params[] = '"' . $k . '"=>' . $v;
        }
        $parse = '<?php ';
        $parse .= 'echo \addons\yccms\library\tag\TagControls::getTagSingle(['. implode(',', $params).']);';
        $parse .= ' ?>';
        return $parse;
    }

    /**
     * 获取配置项
     * @param $tag['site'] 配置项调用名
     * @return void
     */
    public function tagConfig($tag):string
    {
        $name = $tag['name']??'';
        $res = yc_get_config($name)??'';
        if (is_array($res)){
            throw new Exception("配置项\"$name\"为数组，请使用\"config_arr\"标签");
        }
        if (isset($tag['is_http']) && ($tag['is_http'] == 1)){
            $res = cdnurl($res,true);
        }
        return $res;
    }

    /**
     * 获取配置项 数组类型
     * @param $tag['site'] 配置项调用名
     * @return void
     */
    public function tagConfig_arr($tag,$content):string
    {
        $name = $tag['name'];
        $res = yc_get_config($name)??[];
        if (!is_array($res)){
            throw new Exception("配置项\"$name\"非数组结构，请使用\"config\"标签");
        }
        $this_d = [];
        foreach ($res as $key => $val){
            if (isset($tag['is_http']) && ($tag['is_http'] == 1)) $val = cdnurl($val,true);
            $this_d[] = ['key'=>$key,'val'=>$val];
        }
        $this_data = $this_d;
        $parse = '<?php ';
        $parse .= '$config = json_decode(\''.json_encode($this_data).'\',true);';
        $parse .= ' ?>';
        $parse .= '{volist name="config" id="' . $tag['id'] . '" key="'.$tag['key'].'"}';
        $parse .= $content;
        $parse .= '{/volist}';
        return $parse;
    }

    public function autoBuildVar(&$name)
    {
        //如果是字符串则特殊处理
        if (preg_match("/^('|\")(.*)('|\")\$/i", $name, $matches)) {
            $quote = $matches[1] == '"' ? "'" : '"';
            $name = $quote . $matches[2] . $quote;
            return $name;
        }
        return parent::autoBuildVar($name);
    }
}
