<?php
namespace addons\yccms\library\tool\template;

use think\Exception;

class Single
{

    /**
     * 单页模版组合前部分代码
     * @param $param 参数
     * @return string
     */
    public static function single_head($param = []): string
    {
        $name = $param['name'];
        $class_name = ucfirst($param['identification']);
        $file_name = $param['identification_zh'];
        $con = <<<str
<?php
namespace addons\yccms\controller\single;

use addons\yccms\controller\common\BaseSingle;

/**
 * $name
 */
class $class_name extends BaseSingle
{
    /**
     * 单页模版首页 可自行更改代码
     */
    public function index(){
        return view("\$this->is_pc_template/single/$file_name");
    }
}
str;
        return $con;
    }

    /**
     * 单页相关文件生成
     * @param $param 参数
     * @return string
     */
    public static function single_controls($param = []){
        //1.验证参数
        if (empty($param)){
            throw new Exception('参数有误，无法为您生成Controller文件！');
        }
        $url_arr = [];
        //2.生成控制器文件
        $html = self::single_head($param);
        $file_name = $param['identification'].'.php';
        $full_path = ADDON_PATH . 'yccms/controller/single/'.$file_name;
        if (file_exists($full_path)){
            throw new Exception("$full_path 文件已经存在！");
        }
        file_put_contents($full_path, $html);
        $url_arr[] = ['name'=>'controller_url','zh_name'=>'控制器文件','file_name'=>$file_name,'url'=>str_replace(ADDON_PATH,"",$full_path)];
        //3.生成静态模版文件
        $view_all = ['pc','mobile'];
        $zh_view_all =  ['pc'=>'pc模版','mobile'=>'mobile模版'];
        if ($param['is_type'] == 1)unset($view_all[1]);
        if ($param['is_type'] == 2)unset($view_all[0]);
        $view_path = ADDON_PATH . 'yccms/view/';
        foreach ($view_all as $item){
            $con = <<<str
{extend name="$item/common/base" /}
{block name="content"}
    <!--这部分是您所要更改的内部-->
{/block}
str;
            $v_url = $view_path . $item . '/single/' . $param['identification_zh'] .'.html';
            if (file_exists($v_url)){
                throw new Exception("$v_url 文件已经存在！");
            }
            file_put_contents($v_url, $con);
            $url_arr[] =  ['name'=>$item,'zh_name'=>$zh_view_all[$item],'file_name'=>$param['identification_zh'] .'.html','url'=>str_replace(ADDON_PATH,"",$v_url)];
        }
        //4.更改插件伪静态
        $rewrite =  get_addon_config('yccms')['rewrite'];
        if (!isset($rewrite['single.' . $param['identification_zh'] . '/index'])){
            $rewrite['single.' . $param['identification_zh'] . '/index'] = "/yccms/single/". $param['identification_zh']."/[:cid]";
        }
        set_addon_config('yccms', ['rewrite'=>$rewrite], true);
        return $url_arr;
    }


}