<?php
namespace addons\yccms\library\tool\template;

use think\addons\Service;
use think\Exception;

class ListRule
{

    /**
     * 列表控制器
     * @param $param 参数
     * @return string
     */
    public static function add_controller($param = []): string
    {
        $name = $param['name'];
        $class_name = $param['identification'];
        $class_name_zh = $param['identification_zh'];
        $con = <<<str
<?php
namespace addons\yccms\controller\\rule_list;


use addons\yccms\controller\common\BaseList;

/**
 * $name
 */
class $class_name extends BaseList
{
    
    public \$class_name = "$class_name_zh";

    public function _initialize()
    {
        parent::_initialize(); // TODO: Change the autogenerated stub
    }



}
str;
        return $con;
    }


    /**
     * 列表模型
     * @param $param 参数
     * @return string
     */
    public static function add_model($param = []): string
    {
        $name = $param['name'];
        $class_name = $param['identification'];
        $class_name_zh = $param['identification_zh'];
        $con = <<<str
<?php
namespace addons\yccms\model\\rule_list;

use addons\yccms\model\BaseModel;
/**
 * $name
 */
class $class_name extends BaseModel
{
    // 表名
    protected \$name = "yccms_list_$class_name_zh";

}
str;
        return $con;
    }





    /**
     * 列表相关文件生成
     * @param $param 参数
     * @return string
     */
    public static function list_controls($param = []){
        //1.验证参数
        if (empty($param)){
            throw new Exception('参数有误，无法为您生成Controller文件！');
        }
        $url_arr = [];
        //2.生成控制器文件
        $html = self::add_controller($param);
        $full_path = ADDON_PATH . 'yccms/controller/rule_list/'.$param['identification'].'.php';
        if (file_exists($full_path)){
            throw new Exception("$full_path 文件已经存在！");
        }
        file_put_contents($full_path, $html);
        $url_arr[] = ['name'=>'controller_url','zh_name'=>'控制器文件','file_name'=>$param['identification'].'.php','url'=>str_replace(ADDON_PATH,"",$full_path)];
        //3.生成模型文件
        $model_html = self::add_model($param);
        $model_path = ADDON_PATH . 'yccms/model/rule_list/'.$param['identification'].'.php';
        if (file_exists($model_path)){
            throw new Exception("$model_path 文件已经存在！");
        }
        file_put_contents($model_path, $model_html);
        $url_arr[] = ['name'=>'model_url','zh_name'=>'模型文件','file_name'=>$param['identification'].'.php','url'=>str_replace(ADDON_PATH,"",$model_path)];
        //3.生成静态模版文件
        $view_all = ['pc','mobile'];
        $zh_view_all =  ['pc'=>['pc列表页模版','pc详情页模版'],'mobile'=>['mobile列表页模版','mobile详情页模版']];
        if ($param['is_type'] == 1)unset($view_all[1]);
        if ($param['is_type'] == 2)unset($view_all[0]);
        $view_path = ADDON_PATH . 'yccms/view/';
        foreach ($view_all as $item){
            //检测文件夹
            if (!file_exists($view_path . $item . '/rule_list/' . $param['identification_zh'])){
                mkdir($view_path . $item . '/rule_list/' . $param['identification_zh'], 0777, true);
            }
            //创建文件
            $con = <<<str
{extend name="$item/common/base" /}
{block name="content"}
    <!--这部分是您所要更改的内部-->
{/block}
str;
            $this_url_all = [
                $view_path . $item . '/rule_list/' . $param['identification_zh'] . '/index.html',
                $view_path . $item . '/rule_list/' . $param['identification_zh'] . '/details.html'
            ];
            $this_url_text = ['index.html', 'details.html'];
            foreach ($this_url_all as $k => $i){
                if (file_exists($i)){
                    throw new Exception("$i 文件已经存在！");
                }
                file_put_contents($i, $con);
                $url_arr[] =  ['name'=>$item,'zh_name'=>$zh_view_all[$item][$k],'file_name'=>$this_url_text[$k],'url'=>str_replace(ADDON_PATH,"",$i)];
            }
        }
        //4.更改插件伪静态
        $rewrite =  get_addon_config('yccms')['rewrite'];
        if (!isset($rewrite['list.' . $param['identification_zh'] . '/index'])){
            $rewrite['rule_list.' . $param['identification_zh'] . '/index'] = "/yccms/". $param['identification_zh'].'/index/[:cid]';
        }
        if (!isset($rewrite['list.' . $param['identification_zh'] . '/details'])){
            $rewrite['rule_list.' . $param['identification_zh'] . '/details'] = "/yccms/". $param['identification_zh'].'/details/[:cid]/[:id]';
        }
        set_addon_config('yccms', ['rewrite'=>$rewrite], true);
        Service::refresh();
        return $url_arr;
    }


}