<?php
namespace addons\yccms\library\tag;

use app\admin\controller\yccms\ListData;
use PDOStatement;
use think\Collection;
use think\Db;
use think\db\Query;
use think\Exception;
use think\Paginator;
/**
 * tab 操作类
 * 此文件请谨慎更改
 */
class TagControls
{

    /**
     * 栏目标签调用方法
     * @param array $params
     */
    public static function getTagCategory(array $params = [])
    {
        try {
            //1.设置参数
            foreach ($params as $index => $val){
                $$index = $val;
            }
            //2.获取栏目数据
            $cate_info = yc_file_get_contents();
            if (empty($cate_info))throw new Exception('栏目数据不存在');
            //3.判断数据
            $res_data = self::yc_crate_taglib($cate_info,$params);
            //4.如果pid不是0
            if (!empty($pid) && !empty($res_data[0]) && !empty($res_data[0]['son'])){
                $res_data = $res_data[0]['son'];
            }
            //5.监听底部
            if (($pid == 0) && ($is_cate_stu == 2) && ($is_footer_stu >= 2)){
                $info = [];
                foreach ($res_data as  $key => $item){
                    if (empty($item['son'])){
                        if (empty($info)){
                            $info = $item;
                            unset($res_data[$key]);
                            continue;
                        }
                        if (!empty($info))$info['son'][] = $item;
                        unset($res_data[$key]);
                    }
                }
                $is_footer_stu == 2?array_unshift($res_data, $info):array_push($res_data, $info);
            }
        } catch (Exception $e) {
            trace($e->getMessage(),'error');
            trace($e->getLine(),'error');
            return [];
        }
        return $res_data;
    }



    /**
     * 获取单个栏目信息
     * @param array $params
     */
    public static function getTagCategoryInfo(array $params = [])
    {
        $name = '';
        try {
            //1.设置参数
            foreach ($params as $index => $val){
                $$index = $val;
            }
            //2.获取栏目数据
            $cate_info = yc_recursion_one_data([],[['id','==',$cid]]);
            if (empty($cate_info))throw new Exception('栏目数据不存在');
            //3.判断数据
            if (isset($cate_info[$name]))$name = $cate_info[$name];
        } catch (Exception $e) {
            return '';
        }
        return $name;
    }


    /**
     * 递归栏目操作
     * @param $data
     * @param $params
     * @return array
     */
    public static function yc_crate_taglib($data = [], $params = []): array
    {
        $array = [];
        //1.赋值变量
        foreach ($params as $index => $val){
            $$index = $val;
        }
        //2.循环数据 判断数据
        foreach ($data??[] as $item){
            //查询顶级栏目
            if (($is_cate_stu == 1) && ($item['is_nav_show'] == 0))continue;
            //查询底级栏目
            if (($is_cate_stu == 2) && ($item['is_flooter_nav_show'] == 0))continue;
            //监测删除或者隐藏
            if (!empty($item['deletetime']))continue;
            //隐藏数据
            $hidden = ['is_nav_show','is_flooter_nav_show','weigh','deletetime'];
            foreach ($item as $k => $v){
                if (in_array($k,$hidden))unset($item[$k]);
                if ($k == 'createtime')$item[$k] = date('Y-m-d H:i:s',$item['createtime']);
                if ($k == 'updatetime')$item[$k] = date('Y-m-d H:i:s',$item['updatetime']);
            }
            //递归查询数据
            if (isset($item['son']) && is_array($item['son'])){
                $params['pid'] = $item['id'];
                $item['son'] = self::yc_crate_taglib($item['son'],$params);
            }
            //监测pid
            if (!empty($pid)){
                if (($item['pid'] != $pid) && ($item['id'] != $pid))continue;
            }
            //查询跳转url
            $skip_url = yc_addon_url($item);
            if (($item['status'] == 3) && $item['url']){
                $skip_url = $item['url'];
            }else if(!empty($item['son']) && !empty($is_cate_url)){
                foreach ($item['son'] as $it){
                    if (!empty(yc_addon_url($it))){
                        $skip_url = yc_addon_url($it);
                        break;
                    };
                }
            }
            $item['skip_url'] = empty($skip_url)?'javascript:;':$skip_url;
            //查询是否当前栏目为'当前栏目或当前栏目的腹肌栏目'
            $item['is_current'] = yc_is_current($item);
            //底部栏目
            if (($item['pid'] == 0) && empty($item['son']) && ($is_cate_stu == 2) && ($is_footer_stu == 1)){
                continue;
            }
            $array[] = $item;
        }
        return $array;
    }



    /**
     * 查询轮播图数组
     * @return void
     */
    public static function getTagBanners(array $params = [])
    {
        $res_data = \db('yccms_banners')->where('deletetime',null)->where('status',1);
        try {
            //1.设置参数
            foreach ($params as $index => $val){
                $$index = $val;
            }
            $group = [];
            $cid = input('param.cid')??0;
            //2. 如果分组存在查询分组
            if (!empty($group_id)){
                $group = \db('yccms_banners_group')->where('id',$group_id)->find();
            }
            //3.如果分组不存在 并且 banner_ids 亦不存在
            if (empty($group) && empty($banner_ids) && $cid){
                $group_list = \db('yccms_banners_group')->select();
                foreach ($group_list as $gr){
                    $category_ids = explode(',',$gr['yccms_category_ids']);
                    if (in_array($cid,$category_ids)){
                        $group = $gr;
                        break;
                    }
                }
            }
            //4 如果分组存在 查询分组
            if(!empty($group)){
                $banners_ids = explode(',',$group['yccms_banners_ids']);
                if (!empty($banners_ids)){
                    $res_data->whereIn('id',$banners_ids);
                }
                //4.1 如果到现在分组还不存在 并且
            }else if(empty($group) && $banner_ids){
                $banner_ids = explode(',',$banner_ids);
                $res_data->whereIn('id',$banner_ids);
            }else{
                $res_data->where('id',0);
            }
            //5 查询
            $res_data = $res_data->select();
        } catch (Exception $e) {
            return [];
        }
        return $res_data;
    }

    /**
     * 查询单页参数
     * @return void
     */
    public static function getTagSingle(array $params = []){
        $name_stu = '';
        try {
            //1.设置参数
            foreach ($params as $index => $val){
                $$index = $val;
            }
            //2.查询单页
            $single_info = yc_recursion_one_data('single.php',[['id','==',$single_id]]);
            if (empty($single_info))throw new Exception('单页不存在');
            //5.查询规则
            if (empty($single_info['argument']) || empty($single_info['argument_rule']))throw new Exception('单页规则不存在');
            //6.查询
            $argument = $single_info['argument'];
            foreach ($argument as $item){
                if ($item['name'] == $name){
                    $name_stu = $item['value'];
                }
            }
        } catch (Exception $e) {
            return '';
        }
        return $name_stu;
    }



    /**
     * 列表标签调用方法
     * @param array $params
     * @return array|bool|PDOStatement|string|Collection|Query|Paginator
     */
    public static function getPageData(array $params = [])
    {
        try {
            //1.设置参数
            foreach ($params as $index => $val){
                $$index = $val;
            }
            //2.监测栏目
            $cate_info = yc_recursion_one_data([],[['id','==',$category_id]],'son',true);
            if (empty($cate_info))throw new Exception('category_id 参数错误');
            $cate_ids = [];
            //3.查询当前栏目和子栏目数据
            if ($son == 2){
                $cate_list = yc_recursion_data([],[
                    ['pid','==',$cate_info['id']],
                    ['status','==',2],
                    ['yccms_rule_id','==',$cate_info['yccms_rule_id']]
                ],'son',true);
                $cate_ids = array_reduce($cate_list, function($carry, $item) {
                    $carry[] = $item['id'];
                    return $carry;
                }, array());
            }
            $cate_ids[] = $cate_info['id'];
            //4.获取规则
            $rule_list = yc_recursion_one_data('rule.php',[['id','==',$cate_info['yccms_rule_id']]],'son',true);
            if (empty($rule_list))throw new Exception('栏目id为'.$cate_info['id'].'的栏目列表类型不存在');
            //5.查询数据表字段
            $rule_list_sql = "SHOW FULL COLUMNS FROM " . config('database.prefix') . "yccms_list_" . $rule_list['identification_zh'];
            $rule_fields = Db::query($rule_list_sql);
            $rule_fields = array_reduce($rule_fields, function($carry, $item) {
                $carry[$item['Field']] = 1;
                return $carry;
            }, array());
            //6.使用db查询数据
            $list = \db('yccms_list_'.$rule_list['identification_zh']);
            //7.判断栏目数据
            $list = $list->whereIn('yccms_category_id',$cate_ids);
            //8.判断字段显示
            if (($is_field == 1) && !empty($field)){
                //监测字段 避免报错
                $new_field = [];
                foreach (explode(',',$field) as $item){
                    if (isset($rule_fields[$item]))$new_field[] = $item;
                }
                $list = $list->field($new_field);
            }
            //9.隐藏字段
            if ($is_field == 2 && !empty($no_field)){
                //监测字段 避免报错
                $new_no_field = [];
                foreach (explode(',',$no_field) as $item){
                    if (isset($rule_fields[$item]))$new_no_field[] = $item;
                }
                $list = $list->field($new_no_field,true);
            }
            //10.缓存查询
            if (!empty($cache)){
                $list = $list->cache($cache);
            }
            //11.排序
            $order_by = [];
            $order_by[$orderby] = $orderway;
            if (isset($rule_fields['weigh']))$order_by['weigh'] = 'desc';
            if (isset($rule_fields['updatetime']))$order_by['updatetime'] = 'desc';
            if (isset($rule_fields['id']))$order_by['id'] = 'desc';
            //12. 固定不显示删除的数据
            if (isset($rule_fields['deletetime'])){
                $list = $list->where('deletetime',null);
            }
            //13.分页
            if ($is_page == 1){
                $params = request()->param();
                if (isset($params['cid']))unset($params['cid']);
                if (isset($params['id']))unset($params['id']);
                $list = $list->order($order_by)->paginate($rows,$is_easy,['query'=>$params])->each(function($item, $key) use ($rule_fields,$date){
                    //追加格式化时间
                    if (isset($rule_fields['createtime']) && isset($item['createtime']))$item['createtime_text'] = date($date,$item['createtime']);
                    if (isset($rule_fields['updatetime']) && isset($item['updatetime']))$item['updatetime_text'] = date($date,$item['updatetime']);
                    if (isset($rule_fields['deletetime']) && isset($item['deletetime']))$item['deletetime_text'] = date($date,$item['deletetime']);
                    //跳转路由
                    $item['skip_url'] = yc_addon_url($item,[],2);
                    return $item;
                });
            }
            //13非分页数据
            if ($is_page == 2){
                if (!empty($limit)){
                    $list = $list->limit($limit);
                }
                $list = $list->order($order_by)->select();
                if ($list){
                    $list = \collection($list)->toArray();
                    foreach($list as &$item){
                        //追加格式化时间
                        if (isset($rule_fields['createtime']) && isset($item['createtime']))$item['createtime_text'] = date('Y-m-d H:i:s',$item['createtime']);
                        if (isset($rule_fields['updatetime']) && isset($item['updatetime']))$item['updatetime_text'] = date('Y-m-d H:i:s',$item['updatetime']);
                        if (isset($rule_fields['deletetime']) && isset($item['deletetime']))$item['deletetime_text'] = date('Y-m-d H:i:s',$item['deletetime']);
                        //跳转路由
                        $item['skip_url'] = yc_addon_url($item,[],2);
                    }
                }
            }
        } catch (Exception $e) {
            return [];
        }
        return $list;
    }

    /**
     * 获取详情
     * @return void
     */
    public static function getTagDetails($tag = []):array
    {
        $tag['id'] = !empty($tag['id'])?$tag['id']:(int) input('param.id');
        $tag['cid'] = !empty($tag['cid'])?$tag['cid']:(int) input('param.cid');
        if (empty($tag['name']))\exception('字段名不能为空');
        if (empty($tag['id']))\exception('id不能为空');
        if (empty($tag['cid']))\exception('cid不能为空');
        $data = [];
        //查询数据
        $this_cate = yc_recursion_one_data('',[['id','==',$tag['cid']]]);
        if (empty($this_cate))return $data;
        $this_rule = yc_recursion_one_data('rule.php',[['id','==',$this_cate['yccms_rule_id']]]);
        if (empty($this_rule))return $data;
        //查询数据
        $where = ['id'=>$tag['id'],'yccms_category_id'=>$this_cate['id']];
        $or = 'desc';
        $cache_str = '';
        if (!empty($tag['controls'])){
            //上一页
            $where['id'] = ['<',$tag['id']];
            $cache_str = '_a';
            //下一页
            if ($tag['controls'] == 'after'){
                $where['id'] = ['>',$tag['id']];
                $or = 'asc';
                $cache_str = '_b';
            }
        }
        $data = Db::name($this_rule['table_name'])->where($where)->order('id',$or)->cache($this_rule['identification_zh'].'_'.$tag['id'].$cache_str,3)->find();
        if (empty($data))return [];
        //查询栏目
        $this_cate = yc_recursion_one_data('',[['id','==',$data['yccms_category_id']]]);
        if (empty($this_cate))return [];
        //赋值
        $data['cate_name'] = $this_cate['name'];
        $data['cate_subheading'] = $this_cate['subheading'];
        $data['cate_status'] = $this_cate['status'];
        $data['cate_url'] = $this_cate['url'];
        $data['skip_url'] = yc_addon_url($data,[],2);
        $argument = $data[$tag['name']]??'';
        //数组
        if (!empty($tag['is_arr'])){
            $separator = $tag['separator']??',';
            $argument = explode($separator,$argument);
            foreach ($argument as &$item){
                if (is_string($item) && $tag['is_domain']){
                    $item = cdnurl($item,true);
                }
            }
            return $argument;
        }
        //截取字符串
        if (!empty($tag['omit'])){
            $omit = explode('|',$tag['omit']);
            if (strlen($argument) > $omit[0]??20)$argument = substr($argument,0,$omit[0]??20).($omit[1]??'...');
        }
        //时间格式
        if (is_int($argument) && !empty($tag['time'])){
            $data[] = date($tag['time'],$argument);
            return $data;
        }
        //添加域名
        if (is_string($argument) && !empty($tag['is_domain'])){
            $data[] = cdnurl($argument,true);
            return $data;
        }
        //注解
        if ($argument && !empty($tag['is_annotation'])){
            //查询表结构
            $structure = Db::query("SHOW FULL COLUMNS FROM " . config('database.prefix') . $this_rule['table_name']);
            foreach ($structure as $item){
                if ($item['Field'] == $tag['name']){
                    $Comment = $item['Comment'];
                    $CommentArr = (new ListData())->getCommentArr(['field_name'=>$Comment,'data'=>[]]);
                    if (!empty($CommentArr['data'])){
                        $data[] = $CommentArr['data'][$argument]??$argument;
                        return $data;
                    }
                }
            }
        }
        $data[] = $argument;
        return $data;
    }





}