<?php

namespace addons\yccms\library\Translate\platform;

class Youdao
{
    //请求url
    private $http_url = "https://openapi.youdao.com/translate_html";
    //您的应用ID
    private $app_key;
    //您的应用密钥
    private $sec_key;

    //初始化
    public function __construct()
    {
        $this->app_key = yc_get_config('yd_app_key');
        $this->sec_key = yc_get_config('yd_sec_key');
    }

    /**
     * 请求前置验证
     */
    public function ver_request($q,$to){
        $res = ['code'=>0,'msg'=>''];
        //应用ID
        if (empty($this->app_key))$res['msg'] = '应用ID不能为空';
        //应用秘钥
        if (empty($this->sec_key))$res['msg'] = '应用秘钥不能为空';
        //发起请求
        $ret = $this->do_request($q,$to);
        $ret = json_decode($ret, true);
        if (($ret['errorMessage'] == "success") && ($ret['errorCode'] == 0)){
            return ['code' => 1,'msg' => '翻译成功','data' => $ret['data']['translation']];
        }
        //错误返回
        $errArr = include ADDON_PATH . 'yccms' . DS . 'library'. DS . 'Translate' . DS . 'err' . DS . 'Youdao.php';
        $res['msg'] = $errArr[$ret['errorCode']];
        return $res;
    }

    /**
     * 发起http请求
     * @param $q
     * @return bool|mixed|string
     */
    public function do_request($q,$to)
    {
        $salt = $this->create_guid();
        $args = array(
            'q' => $q,
            'appKey' => $this->app_key,
            'secKey' => $this->sec_key,
            'salt' => $salt,
            'from' => 'zh-CHS',
            'to' => $to,
            'signType' => 'v3',
            'curtime' => strtotime("now"),
        );
        $signStr = $args['appKey'] . $this->truncate($q) . $salt . $args['curtime'] . $args['secKey'];
        $args['sign'] = hash("sha256", $signStr);
        $ret = $this->call($this->http_url, $args);
        return $ret;
    }

    /**
     * 请求前监测请求次数
     * @param $url
     * @param $args
     * @param $method
     * @param $testflag
     * @param $timeout
     * @param $headers
     * @return bool|mixed|string
     */
    public function call($url, $args=null, $method="post", $testflag = 0, $timeout = 2000, $headers=array())
    {
        $ret = false;
        $i = 0;
        while($ret === false)
        {
            if($i > 1)
                break;
            if($i > 0)
            {
                sleep(1);
            }
            $ret = $this->callOnce($url, $args, $method, false, $timeout, $headers);
            $i++;
        }
        return $ret;
    }

    /**
     * 发起网络请求
     * @param $url
     * @param $args
     * @param $method
     * @param $withCookie
     * @param $timeout
     * @param $headers
     * @return bool|string
     */
    public function callOnce($url, $args=null, $method="post", $withCookie = false, $timeout = 2000, $headers=array())
    {
        $ch = curl_init();
        if($method == "post")
        {
            $data = $this->convert($args);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
            curl_setopt($ch, CURLOPT_POST, 1);
        }
        else
        {
            $data = $this->convert($args);
            if($data)
            {
                if(stripos($url, "?") > 0)
                {
                    $url .= "&$data";
                }
                else
                {
                    $url .= "?$data";
                }
            }
        }
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_TIMEOUT, $timeout);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        if(!empty($headers))
        {
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        }
        if($withCookie)
        {
            curl_setopt($ch, CURLOPT_COOKIEJAR, $_COOKIE);
        }
        $r = curl_exec($ch);
        curl_close($ch);
        return $r;
    }

    /**
     * 转换生成后缀参数
     * @param $args
     * @return mixed|string
     */
    public function convert(&$args)
    {
        $data = '';
        if (is_array($args))
        {
            foreach ($args as $key=>$val)
            {
                if (is_array($val))
                {
                    foreach ($val as $k=>$v)
                    {
                        $data .= $key.'['.$k.']='.rawurlencode($v).'&';
                    }
                }
                else
                {
                    $data .="$key=".rawurlencode($val)."&";
                }
            }
            return trim($data, "&");
        }
        return $args;
    }

    /**
     * 生成uuid
     * @return string
     */
    public function create_guid(){
        $microTime = microtime();
        list($a_dec, $a_sec) = explode(" ", $microTime);
        $dec_hex = dechex($a_dec* 1000000);
        $sec_hex = dechex($a_sec);
        $this->ensure_length($dec_hex, 5);
        $this->ensure_length($sec_hex, 6);
        $guid = "";
        $guid .= $dec_hex;
        $guid .= $this->create_guid_section(3);
        $guid .= '-';
        $guid .= $this->create_guid_section(4);
        $guid .= '-';
        $guid .= $this->create_guid_section(4);
        $guid .= '-';
        $guid .= $this->create_guid_section(4);
        $guid .= '-';
        $guid .= $sec_hex;
        $guid .= $this->create_guid_section(6);
        return $guid;
    }

    /**
     * 生成uuid 随机数组
     * @param $characters
     * @return string
     */
    public function create_guid_section($characters){
        $return = "";
        for($i = 0; $i < $characters; $i++)
        {
            $return .= dechex(mt_rand(0,15));
        }
        return $return;
    }

    /**
     * 截断
     * @param $q
     * @return mixed|string
     */
    public function truncate($q) {
        $len = $this->abslength($q);
        return $len <= 20 ? $q : (mb_substr($q, 0, 10) . $len . mb_substr($q, $len - 10, $len));
    }

    /**
     * 返回字符串长度
     * @param $str
     * @return false|int
     */
    public function abslength($str)
    {
        if(empty($str)){
            return 0;
        }
        if(function_exists('mb_strlen')){
            return mb_strlen($str,'utf-8');
        }else {
            preg_match_all("/./u", $str, $ar);
            return count($ar[0]);
        }
    }
    public function ensure_length(&$string, $length){
        $strlen = strlen($string);
        if($strlen < $length)
        {
            $string = str_pad($string, $length, "0");
        }
        else if($strlen > $length)
        {
            $string = substr($string, 0, $length);
        }
    }



}