/*
 Source Server         : 多语言企业官网《API翻译版》
 Source Server Type    : MySQL
 Source Server Version : 50724
*/

SET NAMES utf8mb4;
SET FOREIGN_KEY_CHECKS = 0;

-- ----------------------------
-- 轮播图列表
-- ----------------------------
CREATE TABLE IF NOT EXISTS `__PREFIX__yccms_banners`  (
   `id` int(11) NOT NULL AUTO_INCREMENT,
   `admin_id` int(11) DEFAULT '1' COMMENT '管理员id',
   `title` varchar(255) CHARACTER SET utf8 NOT NULL COMMENT '标题',
   `image` varchar(255) CHARACTER SET utf8 NOT NULL COMMENT '图片',
   `url` varchar(255) CHARACTER SET utf8 DEFAULT NULL COMMENT '链接地址',
   `status` enum('0','1') CHARACTER SET utf8 DEFAULT '1' COMMENT '状态:0=下架,1=上架',
   `weigh` int(10) NOT NULL COMMENT '权重/排序',
   `createtime` bigint(16) DEFAULT NULL COMMENT '创建时间',
   `updatetime` bigint(16) DEFAULT NULL COMMENT '更新时间',
   `deletetime` bigint(16) DEFAULT NULL COMMENT '删除时间',
   PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='轮播图列表';



-- ----------------------------
-- 轮播图分组
-- ----------------------------
CREATE TABLE IF NOT EXISTS `__PREFIX__yccms_banners_group` (
 `id` int(11) NOT NULL AUTO_INCREMENT,
 `admin_id` int(11) DEFAULT '1' COMMENT '管理员id',
 `name` varchar(255) DEFAULT NULL COMMENT '分组名称',
 `yccms_banners_ids` varchar(255) DEFAULT NULL COMMENT '轮播图',
 `yccms_category_ids` varchar(255) DEFAULT NULL COMMENT '多栏目',
 `weigh` int(10) NOT NULL COMMENT '权重/排序',
 `createtime` bigint(16) DEFAULT NULL COMMENT '创建时间',
 `updatetime` bigint(16) DEFAULT NULL COMMENT '更新时间',
 PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='轮播图分组';

-- ----------------------------
-- 栏目管理
-- ----------------------------
CREATE TABLE IF NOT EXISTS `__PREFIX__yccms_category` (
`id` int(10) NOT NULL AUTO_INCREMENT COMMENT '主键',
`name` varchar(255) CHARACTER SET utf8 NOT NULL COMMENT '栏目名称',
`subheading` varchar(255) CHARACTER SET utf8 DEFAULT NULL COMMENT '副标题',
`pid` int(10) NOT NULL DEFAULT '0' COMMENT '父级栏目',
`status` enum('1','2','3') CHARACTER SET utf8 DEFAULT '1' COMMENT '类型:1=单页类型,2=列表类型,3=外链类型',
`yccms_single_id` int(11) DEFAULT NULL COMMENT '单页模版',
`yccms_rule_id` int(11) DEFAULT NULL COMMENT '列表模版',
`url` varchar(255) CHARACTER SET utf8 DEFAULT NULL COMMENT '跳转地址',
`is_nav_show` enum('0','1') CHARACTER SET utf8 NOT NULL DEFAULT '1' COMMENT '顶部导航显示:0=不显示,1=显示',
`is_flooter_nav_show` enum('0','1') CHARACTER SET utf8 NOT NULL DEFAULT '1' COMMENT '底部导航显示:0=不显示,1=显示',
`is_login` enum('0','1') DEFAULT '1' COMMENT '是否登录:0=隐藏1=显示',
`is_list_data` enum('0','1') NOT NULL DEFAULT '1' COMMENT '列表数据显示:0=不显示,1=显示',
`weigh` int(10) DEFAULT NULL COMMENT '权重/排序',
`createtime` bigint(16) DEFAULT NULL COMMENT '创建时间',
`updatetime` bigint(16) DEFAULT NULL COMMENT '更新时间',
`deletetime` bigint(16) DEFAULT NULL COMMENT '删除时间',
PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='栏目管理';


-- ----------------------------
-- 栏目数据数据
-- ----------------------------
INSERT INTO `__PREFIX__yccms_category` (`id`, `name`, `subheading`, `pid`, `status`, `yccms_single_id`, `yccms_rule_id`, `url`, `is_nav_show`, `is_flooter_nav_show`, `is_login`, `is_list_data`, `weigh`, `createtime`, `updatetime`, `deletetime`) VALUES (3, '资质荣誉', '高端容错计算系统研制与应用推广”项目承担单位', 0, '1', 70, 0, '', '1', '1', '0', '0', 9950, 1629297395, 1699653319, NULL);
INSERT INTO `__PREFIX__yccms_category` (`id`, `name`, `subheading`, `pid`, `status`, `yccms_single_id`, `yccms_rule_id`, `url`, `is_nav_show`, `is_flooter_nav_show`, `is_login`, `is_list_data`, `weigh`, `createtime`, `updatetime`, `deletetime`) VALUES (4, '发展历史', '', 0, '1', 69, 0, '', '1', '1', '0', '0', 9999, 1629297617, 1699653307, NULL);
INSERT INTO `__PREFIX__yccms_category` (`id`, `name`, `subheading`, `pid`, `status`, `yccms_single_id`, `yccms_rule_id`, `url`, `is_nav_show`, `is_flooter_nav_show`, `is_login`, `is_list_data`, `weigh`, `createtime`, `updatetime`, `deletetime`) VALUES (5, '宣传视频', '', 0, '2', 0, 13, '', '1', '1', '0', '1', 9900, 1629297944, 1699653246, NULL);
INSERT INTO `__PREFIX__yccms_category` (`id`, `name`, `subheading`, `pid`, `status`, `yccms_single_id`, `yccms_rule_id`, `url`, `is_nav_show`, `is_flooter_nav_show`, `is_login`, `is_list_data`, `weigh`, `createtime`, `updatetime`, `deletetime`) VALUES (6, '新闻资讯', '企业发展携手你我共前进', 0, '2', 0, 9, '', '1', '1', '0', '1', 9800, 1629298102, 1697641617, NULL);
INSERT INTO `__PREFIX__yccms_category` (`id`, `name`, `subheading`, `pid`, `status`, `yccms_single_id`, `yccms_rule_id`, `url`, `is_nav_show`, `is_flooter_nav_show`, `is_login`, `is_list_data`, `weigh`, `createtime`, `updatetime`, `deletetime`) VALUES (7, '国际新闻', '', 6, '2', 0, 9, '', '1', '1', '0', '1', 980, 1629298208, 1699651032, NULL);
INSERT INTO `__PREFIX__yccms_category` (`id`, `name`, `subheading`, `pid`, `status`, `yccms_single_id`, `yccms_rule_id`, `url`, `is_nav_show`, `is_flooter_nav_show`, `is_login`, `is_list_data`, `weigh`, `createtime`, `updatetime`, `deletetime`) VALUES (8, '行业动态', '', 6, '2', 0, 9, '', '1', '1', '0', '1', 999, 1629298231, 1697641625, NULL);
INSERT INTO `__PREFIX__yccms_category` (`id`, `name`, `subheading`, `pid`, `status`, `yccms_single_id`, `yccms_rule_id`, `url`, `is_nav_show`, `is_flooter_nav_show`, `is_login`, `is_list_data`, `weigh`, `createtime`, `updatetime`, `deletetime`) VALUES (9, '产品展示', '创新产品不止于质量 更追求完美', 0, '2', 0, 11, '', '1', '1', '0', '1', 9700, 1629388755, 1697641653, NULL);
INSERT INTO `__PREFIX__yccms_category` (`id`, `name`, `subheading`, `pid`, `status`, `yccms_single_id`, `yccms_rule_id`, `url`, `is_nav_show`, `is_flooter_nav_show`, `is_login`, `is_list_data`, `weigh`, `createtime`, `updatetime`, `deletetime`) VALUES (10, '履带挖掘机', '', 9, '2', 0, 11, '', '1', '1', '0', '1', 990, 1629388854, 1699650456, NULL);
INSERT INTO `__PREFIX__yccms_category` (`id`, `name`, `subheading`, `pid`, `status`, `yccms_single_id`, `yccms_rule_id`, `url`, `is_nav_show`, `is_flooter_nav_show`, `is_login`, `is_list_data`, `weigh`, `createtime`, `updatetime`, `deletetime`) VALUES (11, '轮式挖掘机', '', 9, '2', 0, 11, '', '1', '1', '0', '1', 980, 1629388874, 1699650475, NULL);
INSERT INTO `__PREFIX__yccms_category` (`id`, `name`, `subheading`, `pid`, `status`, `yccms_single_id`, `yccms_rule_id`, `url`, `is_nav_show`, `is_flooter_nav_show`, `is_login`, `is_list_data`, `weigh`, `createtime`, `updatetime`, `deletetime`) VALUES (12, '特种挖掘机', '', 9, '2', 0, 11, '', '1', '1', '0', '1', 970, 1629389857, 1699650490, NULL);
INSERT INTO `__PREFIX__yccms_category` (`id`, `name`, `subheading`, `pid`, `status`, `yccms_single_id`, `yccms_rule_id`, `url`, `is_nav_show`, `is_flooter_nav_show`, `is_login`, `is_list_data`, `weigh`, `createtime`, `updatetime`, `deletetime`) VALUES (13, '大型挖掘机', '', 9, '2', 0, 11, '', '1', '1', '0', '1', 960, 1629389950, 1699650502, NULL);
INSERT INTO `__PREFIX__yccms_category` (`id`, `name`, `subheading`, `pid`, `status`, `yccms_single_id`, `yccms_rule_id`, `url`, `is_nav_show`, `is_flooter_nav_show`, `is_login`, `is_list_data`, `weigh`, `createtime`, `updatetime`, `deletetime`) VALUES (14, '客户案例', '最优质的的服务', 0, '2', 0, 7, '', '1', '1', '0', '1', 9600, 1629391022, 1698916619, NULL);
INSERT INTO `__PREFIX__yccms_category` (`id`, `name`, `subheading`, `pid`, `status`, `yccms_single_id`, `yccms_rule_id`, `url`, `is_nav_show`, `is_flooter_nav_show`, `is_login`, `is_list_data`, `weigh`, `createtime`, `updatetime`, `deletetime`) VALUES (15, '下载中心', '', 0, '2', 68, 8, '', '1', '1', '0', '1', 9500, 1629391209, 1698917821, NULL);
INSERT INTO `__PREFIX__yccms_category` (`id`, `name`, `subheading`, `pid`, `status`, `yccms_single_id`, `yccms_rule_id`, `url`, `is_nav_show`, `is_flooter_nav_show`, `is_login`, `is_list_data`, `weigh`, `createtime`, `updatetime`, `deletetime`) VALUES (17, '在线留言', '', 0, '1', 72, 7, '', '1', '1', '0', '1', 9300, 1629391614, 1698918642, NULL);
INSERT INTO `__PREFIX__yccms_category` (`id`, `name`, `subheading`, `pid`, `status`, `yccms_single_id`, `yccms_rule_id`, `url`, `is_nav_show`, `is_flooter_nav_show`, `is_login`, `is_list_data`, `weigh`, `createtime`, `updatetime`, `deletetime`) VALUES (18, '联系我们', '', 0, '1', 68, 0, 'http://www.baidu.com', '1', '1', '0', '1', 9350, 1629391630, 1697967432, NULL);
INSERT INTO `__PREFIX__yccms_category` (`id`, `name`, `subheading`, `pid`, `status`, `yccms_single_id`, `yccms_rule_id`, `url`, `is_nav_show`, `is_flooter_nav_show`, `is_login`, `is_list_data`, `weigh`, `createtime`, `updatetime`, `deletetime`) VALUES (19, '服务范围', '国内的电子仪器设计服务商之一。多年在电子专业领域积累丰富的设计开发经验', 6, '2', 0, 9, '', '0', '0', '0', '1', 970, 1629699444, 1697641643, NULL);
INSERT INTO `__PREFIX__yccms_category` (`id`, `name`, `subheading`, `pid`, `status`, `yccms_single_id`, `yccms_rule_id`, `url`, `is_nav_show`, `is_flooter_nav_show`, `is_login`, `is_list_data`, `weigh`, `createtime`, `updatetime`, `deletetime`) VALUES (20, '我们的客户', '我们很荣幸地与各单位合作并提供产品和服务', 0, '2', 0, 10, '', '0', '0', '0', '1', 20, 1629707350, 1697641758, NULL);
INSERT INTO `__PREFIX__yccms_category` (`id`, `name`, `subheading`, `pid`, `status`, `yccms_single_id`, `yccms_rule_id`, `url`, `is_nav_show`, `is_flooter_nav_show`, `is_login`, `is_list_data`, `weigh`, `createtime`, `updatetime`, `deletetime`) VALUES (24, '首页', '平台简介', 0, '1', 67, 0, '', '1', '1', '0', '0', 999999, 1695645672, 1699261223, NULL);


-- ----------------------------
-- 插件配置
-- ----------------------------
CREATE TABLE IF NOT EXISTS `__PREFIX__yccms_config` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(30) COLLATE utf8mb4_general_ci DEFAULT '' COMMENT '变量名',
  `group` varchar(30) COLLATE utf8mb4_general_ci DEFAULT '' COMMENT '分组',
  `title` varchar(100) COLLATE utf8mb4_general_ci DEFAULT '' COMMENT '变量标题',
  `tip` varchar(100) COLLATE utf8mb4_general_ci DEFAULT '' COMMENT '变量描述',
  `type` varchar(30) COLLATE utf8mb4_general_ci DEFAULT '' COMMENT '类型:string,text,int,bool,array,datetime,date,file',
  `value` text COLLATE utf8mb4_general_ci COMMENT '变量值',
  `content` text COLLATE utf8mb4_general_ci COMMENT '变量字典数据',
  `rule` varchar(100) COLLATE utf8mb4_general_ci DEFAULT '' COMMENT '验证规则',
  `extend` varchar(255) COLLATE utf8mb4_general_ci DEFAULT '' COMMENT '扩展属性',
  `setting` varchar(255) COLLATE utf8mb4_general_ci DEFAULT '' COMMENT '配置',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `name` (`name`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='插件配置';


-- ----------------------------
-- 配置信息
-- ----------------------------
INSERT INTO `__PREFIX__yccms_config` (`id`, `name`, `group`, `title`, `tip`, `type`, `value`, `content`, `rule`, `extend`, `setting`) VALUES (1, 'categorytype', 'dictionary', 'Category type', '', 'array', '{\"default\":\"Default\",\"page\":\"Page\",\"article\":\"Article\",\"test\":\"Test\"}', '', '', '', NULL);
INSERT INTO `__PREFIX__yccms_config` (`id`, `name`, `group`, `title`, `tip`, `type`, `value`, `content`, `rule`, `extend`, `setting`) VALUES (2, 'configgroup', 'dictionary', 'Config group', '', 'array', '{\"basic\":\"Basic\",\"SiteConfiguration\":\"SiteConfiguration\",\"list_data\":\"ListData\",\"dictionary\":\"Dictionary\",\"translation\":\"Translation\"}', '', '', '', NULL);
INSERT INTO `__PREFIX__yccms_config` (`id`, `name`, `group`, `title`, `tip`, `type`, `value`, `content`, `rule`, `extend`, `setting`) VALUES (3, 'basic_title', 'basic', '站点名称', '', 'string', '多语言企业官网《API翻译版》', '', 'required', '', '\",,,\"');
INSERT INTO `__PREFIX__yccms_config` (`id`, `name`, `group`, `title`, `tip`, `type`, `value`, `content`, `rule`, `extend`, `setting`) VALUES (4, 'site_logo', 'SiteConfiguration', '网站logo', '', 'image', '/assets/addons/yccms/images/common/logo.png', '', 'required', '', '\",,,\"');
INSERT INTO `__PREFIX__yccms_config` (`id`, `name`, `group`, `title`, `tip`, `type`, `value`, `content`, `rule`, `extend`, `setting`) VALUES (5, 'site_relation', 'SiteConfiguration', '联系人', '', 'string', '张小姐', '', '', '', '\",,,\"');
INSERT INTO `__PREFIX__yccms_config` (`id`, `name`, `group`, `title`, `tip`, `type`, `value`, `content`, `rule`, `extend`, `setting`) VALUES (6, 'site_mobile', 'SiteConfiguration', '电话', '', 'string', '010-123456798', '', '', '', '\",,,\"');
INSERT INTO `__PREFIX__yccms_config` (`id`, `name`, `group`, `title`, `tip`, `type`, `value`, `content`, `rule`, `extend`, `setting`) VALUES (7, 'site_email', 'SiteConfiguration', '邮箱', '', 'string', '11111111111@qq.com', '', '', '', '\",,,\"');
INSERT INTO `__PREFIX__yccms_config` (`id`, `name`, `group`, `title`, `tip`, `type`, `value`, `content`, `rule`, `extend`, `setting`) VALUES (8, 'site_address', 'SiteConfiguration', '地址', '', 'string', '某某省某某市某某区某某大厦1805', '', '', '', '\",,,\"');
INSERT INTO `__PREFIX__yccms_config` (`id`, `name`, `group`, `title`, `tip`, `type`, `value`, `content`, `rule`, `extend`, `setting`) VALUES (9, 'site_qrcode', 'SiteConfiguration', '微信二维码', '', 'image', '/assets/addons/yccms/images/common/code.png', '', '', '', '\",,,\"');
INSERT INTO `__PREFIX__yccms_config` (`id`, `name`, `group`, `title`, `tip`, `type`, `value`, `content`, `rule`, `extend`, `setting`) VALUES (10, 'keywords', 'basic', '站点关键词', '', 'string', '关键字1,关键字2', '', 'required', '', '\",,,\"');
INSERT INTO `__PREFIX__yccms_config` (`id`, `name`, `group`, `title`, `tip`, `type`, `value`, `content`, `rule`, `extend`, `setting`) VALUES (11, 'description', 'basic', '站点介绍', '', 'string', '介绍信息介绍信息介绍信息介绍信息介绍信息介绍信息', '', 'required', '', '\",,,\"');
INSERT INTO `__PREFIX__yccms_config` (`id`, `name`, `group`, `title`, `tip`, `type`, `value`, `content`, `rule`, `extend`, `setting`) VALUES (14, 'technical_support', 'SiteConfiguration', '技术支持', '', 'string', '某科技公司', '', '', '', '\",,,\"');
INSERT INTO `__PREFIX__yccms_config` (`id`, `name`, `group`, `title`, `tip`, `type`, `value`, `content`, `rule`, `extend`, `setting`) VALUES (15, 'technical_support_url', 'SiteConfiguration', '技术支持url', '', 'string', 'https://www.baidu.com/', '', '', '', '\",,,\"');
INSERT INTO `__PREFIX__yccms_config` (`id`, `name`, `group`, `title`, `tip`, `type`, `value`, `content`, `rule`, `extend`, `setting`) VALUES (16, 'site_copyright', 'SiteConfiguration', '版权所有', '', 'string', '某商务公司', '', '', '', '\",,,\"');
INSERT INTO `__PREFIX__yccms_config` (`id`, `name`, `group`, `title`, `tip`, `type`, `value`, `content`, `rule`, `extend`, `setting`) VALUES (17, 'site_copyright_url', 'SiteConfiguration', '版权所有url', '', 'string', 'https://www.baidu.com/', '', '', '', '\",,,\"');
INSERT INTO `__PREFIX__yccms_config` (`id`, `name`, `group`, `title`, `tip`, `type`, `value`, `content`, `rule`, `extend`, `setting`) VALUES (18, 'site_beian', 'SiteConfiguration', '网站备案号', '', 'string', 'ICP备888888888号', '', '', '', '\",,,\"');
INSERT INTO `__PREFIX__yccms_config` (`id`, `name`, `group`, `title`, `tip`, `type`, `value`, `content`, `rule`, `extend`, `setting`) VALUES (19, 'site_beian_url', 'SiteConfiguration', '网站备案号url', '', 'string', 'https://www.baidu.com/', '', '', '', '\",,,\"');
INSERT INTO `__PREFIX__yccms_config` (`id`, `name`, `group`, `title`, `tip`, `type`, `value`, `content`, `rule`, `extend`, `setting`) VALUES (20, 'yd_stu', 'translation', '开启翻译', '', 'switch', '1', '', '', '', '\",,,\"');
INSERT INTO `__PREFIX__yccms_config` (`id`, `name`, `group`, `title`, `tip`, `type`, `value`, `content`, `rule`, `extend`, `setting`) VALUES (21, 'yd_app_key', 'translation', '有道翻译应用ID', '', 'string', '', '', '', '', '\",,,\"');
INSERT INTO `__PREFIX__yccms_config` (`id`, `name`, `group`, `title`, `tip`, `type`, `value`, `content`, `rule`, `extend`, `setting`) VALUES (22, 'yd_sec_key', 'translation', '有道翻译应用秘钥', '', 'string', '', '', '', '', '\",,,\"');
INSERT INTO `__PREFIX__yccms_config` (`id`, `name`, `group`, `title`, `tip`, `type`, `value`, `content`, `rule`, `extend`, `setting`) VALUES (23, 'yd_comments', 'translation', '有道翻译对接提示', '', 'text', '本插件使用的是有道翻译中的“网页翻译”，请确保您的有道应用中包含‘文本翻译’和‘网页翻译’服务！', '', '', 'disabled', '\",,,\"');
INSERT INTO `__PREFIX__yccms_config` (`id`, `name`, `group`, `title`, `tip`, `type`, `value`, `content`, `rule`, `extend`, `setting`) VALUES (24, 'yd_arr', 'translation', '语言列表', '', 'array', '{\"zh-CHS\":\"中文简体\",\"zh-CHT\":\"中文繁体\",\"en\":\"English\",\"ar\":\"العربية\",\"de\":\"Deutsch, glaube ich.\",\"es\":\"español\",\"fr\":\"En français\",\"id\":\"Bahasa indonesia\",\"it\":\"Testo italiano\",\"ja\":\"日本 ご 語 です \",\"ko\":\"한글\",\"nl\":\"nederlands\",\"pt\":\"Em português\",\"ru\":\"русск\",\"th\":\"ภาษาไทย\",\"vi\":\"Việt nam\"}', '{\"value1\":\"title1\",\"value2\":\"title2\"}', '', '', '\",,,\"');
INSERT INTO `__PREFIX__yccms_config` (`id`, `name`, `group`, `title`, `tip`, `type`, `value`, `content`, `rule`, `extend`, `setting`) VALUES
(25, 'yccms_list_video', 'list_data', '视频规则', '', 'array', '{\"cids\":\"5\",\"list_fields\":\"source,source_url,click\"}', '{\"value1\":\"title1\",\"value2\":\"title2\"}', '', '', '\",,,\"');
INSERT INTO `__PREFIX__yccms_config` (`id`, `name`, `group`, `title`, `tip`, `type`, `value`, `content`, `rule`, `extend`, `setting`) VALUES (26, 'yccms_list_journalism', 'list_data', '新闻模版', '参数请看文档', 'array', '{\"cids\":\"6,8,7,19\",\"list_fields\":\"weigh,subheading,createtime\",\"cz_fields\":\"\",\"controls\":\"edit,del\",\"add_url\":\"\",\"edit_url\":\"\",\"recyclebin_url\":\"\"}', '{\"value1\":\"title1\",\"value2\":\"title2\"}', '', '', '\",,,\"');



-- ----------------------------
-- 表单管理
-- ----------------------------
CREATE TABLE IF NOT EXISTS `__PREFIX__yccms_form` (
`id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键',
`admin_id` int(11) NOT NULL DEFAULT '1' COMMENT '管理员id',
`name` varchar(255) DEFAULT NULL COMMENT '表单名',
`fields` text COMMENT '字段管理',
`weigh` int(10) NOT NULL DEFAULT '0' COMMENT '权重/排序',
`createtime` bigint(16) DEFAULT NULL COMMENT '创建时间',
`updatetime` bigint(16) DEFAULT NULL COMMENT '更新时间',
PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='表单管理';

-- ----------------------------
-- 表单提交数据
-- ----------------------------
CREATE TABLE IF NOT EXISTS `__PREFIX__yccms_forms` (
 `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键',
 `form_id` int(11) DEFAULT '0' COMMENT '表单id',
 `form_name` varchar(255) DEFAULT NULL COMMENT '表单名称',
 `fields` text COMMENT '字段管理',
 `createtime` bigint(16) DEFAULT NULL COMMENT '创建时间',
 `updatetime` bigint(16) DEFAULT NULL COMMENT '更新时间',
 PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='表单提交数据';

-- ----------------------------
-- 客户案例
-- ----------------------------
CREATE TABLE IF NOT EXISTS `__PREFIX__yccms_list_case_show` (
  `id` int(10) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `admin_id` int(11) DEFAULT '1' COMMENT '管理员id',
  `yccms_category_id` int(10) NOT NULL COMMENT '所属栏目',
  `image` varchar(255) CHARACTER SET utf8 DEFAULT NULL COMMENT '列表图',
  `title` varchar(255) CHARACTER SET utf8 NOT NULL COMMENT '标题',
  `source` varchar(255) CHARACTER SET utf8 DEFAULT NULL COMMENT '来源',
  `source_url` varchar(255) CHARACTER SET utf8 DEFAULT NULL COMMENT '来源地址',
  `click` varchar(255) CHARACTER SET utf8 DEFAULT '0' COMMENT '点击数量',
  `content` text CHARACTER SET utf8 COMMENT '详情',
  `weigh` int(10) NOT NULL COMMENT '权重/排序',
  `createtime` bigint(16) DEFAULT NULL COMMENT '创建时间',
  `updatetime` bigint(16) DEFAULT NULL COMMENT '更新时间',
  `deletetime` bigint(16) DEFAULT NULL COMMENT '删除时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='客户案例';

-- ----------------------------
-- 示例表
-- ----------------------------
CREATE TABLE IF NOT EXISTS `__PREFIX__yccms_list_demo` (
 `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键',
 `admin_id` int(11) NOT NULL DEFAULT '1' COMMENT '管理员id',
 `yccms_category_id` int(10) NOT NULL COMMENT '所属栏目',
 `title` varchar(255) CHARACTER SET utf8 DEFAULT '0' COMMENT '标题',
 `intro` varchar(255) CHARACTER SET utf8 DEFAULT NULL COMMENT '简介',
 `content` text CHARACTER SET utf8 COMMENT '详情',
 `weigh` int(10) NOT NULL DEFAULT '0' COMMENT '权重/排序',
 `createtime` bigint(16) DEFAULT NULL COMMENT '创建时间',
 `updatetime` bigint(16) DEFAULT NULL COMMENT '更新时间',
 `deletetime` bigint(16) DEFAULT NULL COMMENT '删除时间',
 PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='示例表';

-- ----------------------------
-- 下载列表
-- ----------------------------
CREATE TABLE IF NOT EXISTS `__PREFIX__yccms_list_download` (
 `id` int(10) NOT NULL AUTO_INCREMENT COMMENT '主键',
 `admin_id` int(11) DEFAULT '1' COMMENT '管理员id',
 `yccms_category_id` int(10) NOT NULL COMMENT '所属栏目',
 `title` varchar(255) CHARACTER SET utf8 NOT NULL COMMENT '标题',
 `click` varchar(255) CHARACTER SET utf8 DEFAULT '0' COMMENT '下载数量',
 `download_file` varchar(255) CHARACTER SET utf8 DEFAULT NULL COMMENT '下载文件',
 `weigh` int(10) NOT NULL COMMENT '权重/排序',
 `createtime` bigint(16) DEFAULT NULL COMMENT '创建时间',
 `updatetime` bigint(16) DEFAULT NULL COMMENT '更新时间',
 `deletetime` bigint(16) DEFAULT NULL COMMENT '删除时间',
 PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='下载列表';

-- ----------------------------
-- 新闻列表
-- ----------------------------
CREATE TABLE IF NOT EXISTS `__PREFIX__yccms_list_journalism` (
   `id` int(10) NOT NULL AUTO_INCREMENT COMMENT '主键',
   `admin_id` int(11) DEFAULT '1' COMMENT '管理员id',
   `yccms_category_id` int(10) NOT NULL COMMENT '所属栏目',
   `image` varchar(255) CHARACTER SET utf8 DEFAULT NULL COMMENT '列表图',
   `title` varchar(255) CHARACTER SET utf8 NOT NULL COMMENT '标题',
   `subheading` varchar(999) CHARACTER SET utf8 DEFAULT NULL COMMENT '副标题',
   `source` varchar(255) CHARACTER SET utf8 DEFAULT NULL COMMENT '来源',
   `source_url` varchar(255) CHARACTER SET utf8 DEFAULT NULL COMMENT '来源地址',
   `click` varchar(255) CHARACTER SET utf8 DEFAULT '0' COMMENT '点击数量',
   `content` text CHARACTER SET utf8 COMMENT '详情',
   `weigh` int(10) NOT NULL COMMENT '权重/排序',
   `createtime` bigint(16) DEFAULT NULL COMMENT '创建时间',
   `updatetime` bigint(16) DEFAULT NULL COMMENT '更新时间',
   `deletetime` bigint(16) DEFAULT NULL COMMENT '删除时间',
   PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='新闻列表';

-- ----------------------------
-- 我们的客户
-- ----------------------------
CREATE TABLE IF NOT EXISTS `__PREFIX__yccms_list_our_clients` (
    `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键',
    `admin_id` int(11) DEFAULT '1' COMMENT '管理员id',
    `yccms_category_id` int(10) NOT NULL COMMENT '所属栏目',
    `name` varchar(255) CHARACTER SET utf8 DEFAULT NULL COMMENT '客户名称',
    `image` varchar(255) CHARACTER SET utf8 DEFAULT NULL COMMENT '图片',
    `on_image` varchar(255) CHARACTER SET utf8 DEFAULT NULL COMMENT '反向图片',
    `url` varchar(255) CHARACTER SET utf8 DEFAULT NULL COMMENT '点击时跳转链接',
    `click` varchar(255) CHARACTER SET utf8 DEFAULT '0' COMMENT '点击数量(可删除)',
    `content` text CHARACTER SET utf8 COMMENT '详情',
    `weigh` int(10) NOT NULL COMMENT '权重/排序',
    `createtime` bigint(16) DEFAULT NULL COMMENT '创建时间',
    `updatetime` bigint(16) DEFAULT NULL COMMENT '更新时间',
    `deletetime` bigint(16) DEFAULT NULL COMMENT '删除时间',
    PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='我们的客户';

-- ----------------------------
-- 商品列表
-- ----------------------------
CREATE TABLE IF NOT EXISTS `__PREFIX__yccms_list_product` (
    `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键',
    `admin_id` int(11) DEFAULT '1' COMMENT '管理员id',
    `yccms_category_id` int(10) NOT NULL COMMENT '所属栏目',
    `title` varchar(255) CHARACTER SET utf8 NOT NULL COMMENT '名称',
    `image` varchar(255) CHARACTER SET utf8 DEFAULT NULL COMMENT '列表图',
    `serial_number` varchar(255) CHARACTER SET utf8 NOT NULL COMMENT '商品编号',
    `price` decimal(10,2) NOT NULL COMMENT '购买价格',
    `click` int(10) DEFAULT '0' COMMENT '点击次数',
    `content` text CHARACTER SET utf8 COMMENT '详情',
    `weigh` int(10) NOT NULL COMMENT '权重/排序',
    `createtime` bigint(16) DEFAULT NULL COMMENT '创建时间',
    `updatetime` bigint(16) DEFAULT NULL COMMENT '更新时间',
    `deletetime` bigint(16) DEFAULT NULL COMMENT '删除时间',
    PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='商品列表';

-- ----------------------------
-- 视频列表
-- ----------------------------
CREATE TABLE IF NOT EXISTS `__PREFIX__yccms_list_video` (
  `id` int(10) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `admin_id` int(11) DEFAULT '1' COMMENT '管理员id',
  `yccms_category_id` int(10) NOT NULL COMMENT '所属栏目',
  `image` varchar(255) CHARACTER SET utf8 DEFAULT NULL COMMENT '列表图',
  `title` varchar(255) CHARACTER SET utf8 NOT NULL COMMENT '标题',
  `subheading` varchar(999) CHARACTER SET utf8 DEFAULT NULL COMMENT '副标题',
  `source` varchar(255) CHARACTER SET utf8 DEFAULT NULL COMMENT '来源',
  `source_url` varchar(255) CHARACTER SET utf8 DEFAULT NULL COMMENT '来源地址',
  `click` varchar(255) CHARACTER SET utf8 DEFAULT '0' COMMENT '点击数量',
  `video_file` varchar(255) CHARACTER SET utf8 DEFAULT NULL COMMENT '视频',
  `weigh` int(10) NOT NULL COMMENT '权重/排序',
  `createtime` bigint(16) DEFAULT NULL COMMENT '创建时间',
  `updatetime` bigint(16) DEFAULT NULL COMMENT '更新时间',
  `deletetime` bigint(16) DEFAULT NULL COMMENT '删除时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='视频列表';

-- ----------------------------
-- 列表规则
-- ----------------------------
CREATE TABLE IF NOT EXISTS `__PREFIX__yccms_rule` (
    `id` int(10) NOT NULL AUTO_INCREMENT COMMENT '主键',
    `admin_id` int(11) DEFAULT '1' COMMENT '管理员id',
    `name` varchar(255) CHARACTER SET utf8 DEFAULT NULL COMMENT '规则名称',
    `identification` varchar(255) DEFAULT NULL COMMENT '单页标识',
    `identification_zh` varchar(255) DEFAULT NULL COMMENT '非大写标识',
    `template_url` text COMMENT '模版路径',
    `table_name` varchar(255) CHARACTER SET utf8 DEFAULT NULL COMMENT '数据表名称',
    `weigh` int(10) DEFAULT NULL COMMENT '权重/排序',
    `status` enum('1','2') CHARACTER SET utf8 DEFAULT '1' COMMENT '允许栏目设定:1=允许栏目设定,2=不允许栏目设定',
    `createtime` int(10) DEFAULT NULL COMMENT '创建时间',
    `updatetime` int(10) DEFAULT NULL COMMENT '更新时间',
    PRIMARY KEY (`id`) USING BTREE,
    KEY `table_name` (`table_name`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='列表规则';



-- ----------------------------
-- 列表模版数据
-- ----------------------------
INSERT INTO `__PREFIX__yccms_rule` (`id`, `admin_id`, `name`, `identification`, `identification_zh`, `template_url`, `table_name`, `weigh`, `status`, `createtime`, `updatetime`) VALUES (7, 1, '客户案例', 'CaseShow', 'case_show', '[{\"name\":\"controller_url\",\"zh_name\":\"控制器文件\",\"file_name\":\"CaseShow.php\",\"url\":\"yccms\\/controller\\/rule_list\\/CaseShow.php\"},{\"name\":\"pc\",\"zh_name\":\"pc列表页模版\",\"file_name\":\"index.html\",\"url\":\"yccms\\/view\\/pc\\/rule_list\\/case_show\\/index.html\"},{\"name\":\"pc\",\"zh_name\":\"pc详情页模版\",\"file_name\":\"details.html\",\"url\":\"yccms\\/view\\/pc\\/rule_list\\/case_show\\/details.html\"},{\"name\":\"mobile\",\"zh_name\":\"mobile列表页模版\",\"file_name\":\"index.html\",\"url\":\"yccms\\/view\\/mobile\\/rule_list\\/case_show\\/index.html\"},{\"name\":\"mobile\",\"zh_name\":\"mobile详情页模版\",\"file_name\":\"details.html\",\"url\":\"yccms\\/view\\/mobile\\/rule_list\\/case_show\\/details.html\"}]', 'yccms_list_case_show', 999, '1', 1697640805, 1699270485);
INSERT INTO `__PREFIX__yccms_rule` (`id`, `admin_id`, `name`, `identification`, `identification_zh`, `template_url`, `table_name`, `weigh`, `status`, `createtime`, `updatetime`) VALUES (8, 1, '下载列表', 'Download', 'download', '[{\"name\":\"controller_url\",\"zh_name\":\"控制器文件\",\"file_name\":\"Download.php\",\"url\":\"yccms\\/controller\\/rule_list\\/Download.php\"},{\"name\":\"pc\",\"zh_name\":\"pc列表页模版\",\"file_name\":\"index.html\",\"url\":\"yccms\\/view\\/pc\\/rule_list\\/download\\/index.html\"},{\"name\":\"pc\",\"zh_name\":\"pc详情页模版\",\"file_name\":\"details.html\",\"url\":\"yccms\\/view\\/pc\\/rule_list\\/download\\/details.html\"},{\"name\":\"mobile\",\"zh_name\":\"mobile列表页模版\",\"file_name\":\"index.html\",\"url\":\"yccms\\/view\\/mobile\\/rule_list\\/download\\/index.html\"},{\"name\":\"mobile\",\"zh_name\":\"mobile详情页模版\",\"file_name\":\"details.html\",\"url\":\"yccms\\/view\\/mobile\\/rule_list\\/download\\/details.html\"}]', 'yccms_list_download', 998, '1', 1697640831, 1699270485);
INSERT INTO `__PREFIX__yccms_rule` (`id`, `admin_id`, `name`, `identification`, `identification_zh`, `template_url`, `table_name`, `weigh`, `status`, `createtime`, `updatetime`) VALUES (9, 1, '新闻列表', 'Journalism', 'journalism', '[{\"name\":\"controller_url\",\"zh_name\":\"控制器文件\",\"file_name\":\"Journalism.php\",\"url\":\"yccms\\/controller\\/rule_list\\/Journalism.php\"},{\"name\":\"pc\",\"zh_name\":\"pc列表页模版\",\"file_name\":\"index.html\",\"url\":\"yccms\\/view\\/pc\\/rule_list\\/journalism\\/index.html\"},{\"name\":\"pc\",\"zh_name\":\"pc详情页模版\",\"file_name\":\"details.html\",\"url\":\"yccms\\/view\\/pc\\/rule_list\\/journalism\\/details.html\"},{\"name\":\"mobile\",\"zh_name\":\"mobile列表页模版\",\"file_name\":\"index.html\",\"url\":\"yccms\\/view\\/mobile\\/rule_list\\/journalism\\/index.html\"},{\"name\":\"mobile\",\"zh_name\":\"mobile详情页模版\",\"file_name\":\"details.html\",\"url\":\"yccms\\/view\\/mobile\\/rule_list\\/journalism\\/details.html\"}]', 'yccms_list_journalism', 997, '1', 1697640876, 1699270485);
INSERT INTO `__PREFIX__yccms_rule` (`id`, `admin_id`, `name`, `identification`, `identification_zh`, `template_url`, `table_name`, `weigh`, `status`, `createtime`, `updatetime`) VALUES (10, 1, '我们的客户', 'OurClients', 'our_clients', '[{\"name\":\"controller_url\",\"zh_name\":\"控制器文件\",\"file_name\":\"OurClients.php\",\"url\":\"yccms\\/controller\\/rule_list\\/OurClients.php\"},{\"name\":\"pc\",\"zh_name\":\"pc列表页模版\",\"file_name\":\"index.html\",\"url\":\"yccms\\/view\\/pc\\/rule_list\\/our_clients\\/index.html\"},{\"name\":\"pc\",\"zh_name\":\"pc详情页模版\",\"file_name\":\"details.html\",\"url\":\"yccms\\/view\\/pc\\/rule_list\\/our_clients\\/details.html\"},{\"name\":\"mobile\",\"zh_name\":\"mobile列表页模版\",\"file_name\":\"index.html\",\"url\":\"yccms\\/view\\/mobile\\/rule_list\\/our_clients\\/index.html\"},{\"name\":\"mobile\",\"zh_name\":\"mobile详情页模版\",\"file_name\":\"details.html\",\"url\":\"yccms\\/view\\/mobile\\/rule_list\\/our_clients\\/details.html\"}]', 'yccms_list_our_clients', 996, '1', 1697640922, 1699270485);
INSERT INTO `__PREFIX__yccms_rule` (`id`, `admin_id`, `name`, `identification`, `identification_zh`, `template_url`, `table_name`, `weigh`, `status`, `createtime`, `updatetime`) VALUES (11, 1, '商品列表', 'Product', 'product', '[{\"name\":\"controller_url\",\"zh_name\":\"控制器文件\",\"file_name\":\"Product.php\",\"url\":\"yccms\\/controller\\/rule_list\\/Product.php\"},{\"name\":\"pc\",\"zh_name\":\"pc列表页模版\",\"file_name\":\"index.html\",\"url\":\"yccms\\/view\\/pc\\/rule_list\\/product\\/index.html\"},{\"name\":\"pc\",\"zh_name\":\"pc详情页模版\",\"file_name\":\"details.html\",\"url\":\"yccms\\/view\\/pc\\/rule_list\\/product\\/details.html\"},{\"name\":\"mobile\",\"zh_name\":\"mobile列表页模版\",\"file_name\":\"index.html\",\"url\":\"yccms\\/view\\/mobile\\/rule_list\\/product\\/index.html\"},{\"name\":\"mobile\",\"zh_name\":\"mobile详情页模版\",\"file_name\":\"details.html\",\"url\":\"yccms\\/view\\/mobile\\/rule_list\\/product\\/details.html\"}]', 'yccms_list_product', 995, '1', 1697640946, 1699270485);
INSERT INTO `__PREFIX__yccms_rule` (`id`, `admin_id`, `name`, `identification`, `identification_zh`, `template_url`, `table_name`, `weigh`, `status`, `createtime`, `updatetime`) VALUES (13, 1, '视频列表', 'Video', 'video', '[{\"name\":\"controller_url\",\"zh_name\":\"控制器文件\",\"file_name\":\"Video.php\",\"url\":\"yccms\\/controller\\/rule_list\\/Video.php\"},{\"name\":\"pc\",\"zh_name\":\"pc列表页模版\",\"file_name\":\"index.html\",\"url\":\"yccms\\/view\\/pc\\/rule_list\\/video\\/index.html\"},{\"name\":\"pc\",\"zh_name\":\"pc详情页模版\",\"file_name\":\"details.html\",\"url\":\"yccms\\/view\\/pc\\/rule_list\\/video\\/details.html\"},{\"name\":\"mobile\",\"zh_name\":\"mobile列表页模版\",\"file_name\":\"index.html\",\"url\":\"yccms\\/view\\/mobile\\/rule_list\\/video\\/index.html\"},{\"name\":\"mobile\",\"zh_name\":\"mobile详情页模版\",\"file_name\":\"details.html\",\"url\":\"yccms\\/view\\/mobile\\/rule_list\\/video\\/details.html\"}]', 'yccms_list_video', 993, '1', 1697641010, 1699270485);




-- ----------------------------
-- 单页模版
-- ----------------------------
CREATE TABLE IF NOT EXISTS `__PREFIX__yccms_single` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `admin_id` int(11) DEFAULT '1' COMMENT '管理员id',
  `name` varchar(255) CHARACTER SET utf8 NOT NULL COMMENT '单页名称',
  `identification` varchar(255) DEFAULT NULL COMMENT '单页标识',
  `identification_zh` varchar(255) DEFAULT NULL COMMENT '非大写标识',
  `is_type` enum('1','2','3') CHARACTER SET utf8 DEFAULT '3' COMMENT '模版页面:1=pc模版,2=移动模版,3=同时增加pc和移动页面',
  `argument` text COMMENT '参数',
  `argument_rule` text COMMENT '参数规则',
  `template_url` text COMMENT '模版路径',
  `is_home` enum('0','1') DEFAULT '0' COMMENT '设置首页:0=非首页,1=设置为首页',
  `weigh` int(10) NOT NULL COMMENT '权重/排序',
  `createtime` bigint(16) DEFAULT NULL COMMENT '创建时间',
  `updatetime` bigint(16) DEFAULT NULL COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='单页管理';

-- ----------------------------
-- 单页模版数据
-- ----------------------------
INSERT INTO `__PREFIX__yccms_single` (`id`, `admin_id`, `name`, `identification`, `identification_zh`, `is_type`, `argument`, `argument_rule`, `template_url`, `is_home`, `weigh`, `createtime`, `updatetime`) VALUES (67, 1, '首页模版', 'Index', 'index', '3', '[{\"rule_name\":\"111\",\"type\":\"string\",\"name\":\"aaa\",\"value\":\"1111\"},{\"rule_name\":\"222\",\"type\":\"editor\",\"name\":\"bbb\",\"value\":\"2222\"}]', '{\"ja4r3j\":{\"rule_name\":\"1\",\"type\":\"string\",\"name\":\"a\"}}', '[{\"name\":\"controller_url\",\"zh_name\":\"控制器文件\",\"file_name\":\"Index.php\",\"url\":\"yccms\\/controller\\/single\\/Index.php\"},{\"name\":\"pc\",\"zh_name\":\"pc模版\",\"file_name\":\"index.html\",\"url\":\"yccms\\/view\\/pc\\/single\\/index.html\"},{\"name\":\"mobile\",\"zh_name\":\"mobile模版\",\"file_name\":\"index.html\",\"url\":\"yccms\\/view\\/mobile\\/single\\/index.html\"}]', '1', 999, 1695654145, 1699270560);
INSERT INTO `__PREFIX__yccms_single` (`id`, `admin_id`, `name`, `identification`, `identification_zh`, `is_type`, `argument`, `argument_rule`, `template_url`, `is_home`, `weigh`, `createtime`, `updatetime`) VALUES (68, 1, '联系我们', 'Lxwm', 'lxwm', '3', '[{\"rule_name\":\"公司\",\"type\":\"string\",\"name\":\"corporation\",\"value\":\"某某服装有限公司\"},{\"rule_name\":\"联系人\",\"type\":\"string\",\"name\":\"person\",\"value\":\"陈小姐\"},{\"rule_name\":\"电话\",\"type\":\"string\",\"name\":\"telephone\",\"value\":\"010-456123444\"},{\"rule_name\":\"传真\",\"type\":\"string\",\"name\":\"fax\",\"value\":\"010-456123444\"},{\"rule_name\":\"邮件\",\"type\":\"string\",\"name\":\"postalcode\",\"value\":\"400000\"},{\"rule_name\":\"网址\",\"type\":\"string\",\"name\":\"website\",\"value\":\"http:\\/\\/www.baidu.com\"},{\"rule_name\":\"地址\",\"type\":\"string\",\"name\":\"address\",\"value\":\"河北省唐山市某某工业区某某大厦12层1205\"},{\"rule_name\":\"邮件\",\"type\":\"string\",\"name\":\"mail\",\"value\":\"123456789000@qq.com\"}]', '{\"fe9o3q\":{\"rule_name\":\"公司\",\"type\":\"string\",\"name\":\"corporation\"},\"41q6sj\":{\"rule_name\":\"联系人\",\"type\":\"string\",\"name\":\"person\"},\"2zsrg6\":{\"rule_name\":\"电话\",\"type\":\"string\",\"name\":\"telephone\"},\"taz4u4\":{\"rule_name\":\"传真\",\"type\":\"string\",\"name\":\"fax\"},\"06a51b\":{\"rule_name\":\"邮件编码\",\"type\":\"string\",\"name\":\"postalcode\"},\"nx8xqf\":{\"rule_name\":\"网址\",\"type\":\"string\",\"name\":\"website\"},\"itsb59\":{\"rule_name\":\"地址\",\"type\":\"string\",\"name\":\"address\"},\"iwt913\":{\"rule_name\":\"邮件\",\"type\":\"string\",\"name\":\"mail\"}}', '[{\"name\":\"controller_url\",\"zh_name\":\"控制器文件\",\"file_name\":\"Lxwm.php\",\"url\":\"yccms\\/controller\\/single\\/Lxwm.php\"},{\"name\":\"pc\",\"zh_name\":\"pc模版\",\"file_name\":\"lxwm.html\",\"url\":\"yccms\\/view\\/pc\\/single\\/lxwm.html\"},{\"name\":\"mobile\",\"zh_name\":\"mobile模版\",\"file_name\":\"lxwm.html\",\"url\":\"yccms\\/view\\/mobile\\/single\\/lxwm.html\"}]', '0', 999, 1697492613, 1699270560);
INSERT INTO `__PREFIX__yccms_single` (`id`, `admin_id`, `name`, `identification`, `identification_zh`, `is_type`, `argument`, `argument_rule`, `template_url`, `is_home`, `weigh`, `createtime`, `updatetime`) VALUES (69, 1, '发展历史', 'Zzjg', 'zzjg', '3', '[{\"rule_name\":\"详情\",\"type\":\"editor\",\"name\":\"content\",\"value\":\"<p>最初挖掘机是手动的，从发明到2013年已经有一百三十多年了，期间经历了由蒸汽驱动斗回转挖掘机到电力驱动和内燃机驱动回转挖掘机、应用机电液一体化技术的全自动液压挖掘机的逐步发展过程。第一台液压挖掘机由法国波克兰工厂发明成功。由于液压技术的应用，20世纪40年代有了在拖拉机上配装液压反铲地悬挂式挖掘机。1951 年，第一台全液压反铲挖掘机由位于法国的 Poclain（波克兰）工厂推出，从而在挖掘机的技术发展领域开创了全新空间，20世纪50年代初期和中期相继研制出拖式全回转液压挖掘机和履带式全液压挖掘机。初期试制的液压挖掘机是采用飞机和机床的液压技术，缺少适用于挖掘机各种工况的液压元件，制造质量不够稳定，配套件也不齐全。从20世纪60年代起，液压挖掘机进入推广和蓬勃发展阶段，各国挖掘机制造厂和品种增加很快，产量猛增。1968-1970年间，液压挖掘机产量已占挖掘机总产量的83%，已接近100% [2] 。<\\/p><p>第一代挖掘机：电动机、内燃机的出现，使挖掘机有了先进而合适的电动装置，于是各种挖掘机产品相继诞生。1899年，第一台电动挖掘机出现了。第一次世界大战后，柴油发动机也应用在挖掘机上，这种柴油发动机（或电动机）驱动的机械式挖掘机是第一代挖掘机。<\\/p><p>第二代挖掘机：随着液压技术的广泛使用，使挖掘机有了更加科学适用的传动装置，液压传动代替机械传动是挖掘机技术上的一次大飞跃。1950年德国的第一台液压挖掘机诞生了。机械传动液压化是第二代挖掘机。<\\/p><p>第三代挖掘机：电子技术尤其是计算机技术的广泛应用，使挖掘机有了自动化的控制系统，也使挖掘机向高性能、自动化和智能化方向发展。机电一体化的萌芽约发生在1965年前后，而在批量生产的液压挖掘机上采用机电一体化技术则在1985年左右，当时主要目的是为了节能。挖掘机电子化是第三代挖掘机的标志。<\\/p><p>挖掘机行业厂商大致可以分为四类。国内7成以上挖掘机被国外品牌所占据，国产品牌尚以小挖和中挖为主，但国产挖掘机份额正在逐步提升，2012年同比提高3.6%。<\\/p><p><br\\/><\\/p>\"}]', '{\"kvbgmf\":{\"rule_name\":\"详情\",\"type\":\"editor\",\"name\":\"content\"}}', '[{\"name\":\"controller_url\",\"zh_name\":\"控制器文件\",\"file_name\":\"Zzjg.php\",\"url\":\"yccms\\/controller\\/single\\/Zzjg.php\"},{\"name\":\"pc\",\"zh_name\":\"pc模版\",\"file_name\":\"zzjg.html\",\"url\":\"yccms\\/view\\/pc\\/single\\/zzjg.html\"},{\"name\":\"mobile\",\"zh_name\":\"mobile模版\",\"file_name\":\"zzjg.html\",\"url\":\"yccms\\/view\\/mobile\\/single\\/zzjg.html\"}]', '0', 998, 1698549770, 1699653056);
INSERT INTO `__PREFIX__yccms_single` (`id`, `admin_id`, `name`, `identification`, `identification_zh`, `is_type`, `argument`, `argument_rule`, `template_url`, `is_home`, `weigh`, `createtime`, `updatetime`) VALUES (70, 1, '荣誉资质', 'Ryzz', 'ryzz', '3', '[{\"rule_name\":\"荣誉资质\",\"type\":\"image\",\"name\":\"image\",\"value\":\"\\/assets\\/addons\\/yccms\\/images\\/data\\/ryzz.png\"}]', '{\"lqmsan\":{\"rule_name\":\"荣誉资质\",\"type\":\"image\",\"name\":\"image\"}}', '[{\"name\":\"controller_url\",\"zh_name\":\"控制器文件\",\"file_name\":\"Ryzz.php\",\"url\":\"yccms\\/controller\\/single\\/Ryzz.php\"},{\"name\":\"pc\",\"zh_name\":\"pc模版\",\"file_name\":\"ryzz.html\",\"url\":\"yccms\\/view\\/pc\\/single\\/ryzz.html\"},{\"name\":\"mobile\",\"zh_name\":\"mobile模版\",\"file_name\":\"ryzz.html\",\"url\":\"yccms\\/view\\/mobile\\/single\\/ryzz.html\"}]', '0', 997, 1698550650, 1699662459);
INSERT INTO `__PREFIX__yccms_single` (`id`, `admin_id`, `name`, `identification`, `identification_zh`, `is_type`, `argument`, `argument_rule`, `template_url`, `is_home`, `weigh`, `createtime`, `updatetime`) VALUES (72, 1, '在线留言', 'Zxly', 'zxly', '3', NULL, NULL, '[{\"name\":\"controller_url\",\"zh_name\":\"控制器文件\",\"file_name\":\"Zxly.php\",\"url\":\"yccms\\/controller\\/single\\/Zxly.php\"},{\"name\":\"pc\",\"zh_name\":\"pc模版\",\"file_name\":\"zxly.html\",\"url\":\"yccms\\/view\\/pc\\/single\\/zxly.html\"},{\"name\":\"mobile\",\"zh_name\":\"mobile模版\",\"file_name\":\"zxly.html\",\"url\":\"yccms\\/view\\/mobile\\/single\\/zxly.html\"}]', '0', 995, 1698918419, 1699270560);

SET FOREIGN_KEY_CHECKS = 1;