<?php

namespace addons\yccms\controller\common;

use app\common\controller\Frontend;
use fast\Random;
use think\addons\Controller;
use think\Cookie;
use think\Hook;

class BaseController extends Controller
{
    //手机端和pc调用模版判断标识
    protected $is_pc_template = 'pc';
    protected $noNeedLogin = '*';
    protected $noNeedRight = '*';
    protected $layout = '';
    protected $id = 0;

    public function _initialize()
    {
        parent::_initialize(); // TODO: Change the autogenerated stub
        //如果不是两套模版，请将此行代码注释
        if ($this->isMobile()){
            $this->is_pc_template = 'mobile';
        }
        cookie('yc_pc_template',$this->isMobile()?'mobile':'pc',3600);
        if (!cookie('yccms_lang'))cookie('yccms_lang','zh-CHS',3600);
        $this->setVariableOutput();
        $basic = [
            'title'       => yc_get_config('basic_title'),
            'keywords'    => yc_get_config('keywords'),
            'description' => yc_get_config('description')
        ];
        $this->view->assign('captchaType', config('fastadmin.user_register_captcha'));
        $this->assign('basic', $basic);
        $this->assign('auth',$this->auth);
    }

    /**
     * 设置翻译
     * @return void
     */
    public function lang_set(){
        $lang = input('get.yc_lang')??'';
        $lan_arr = ['zh-CHS', 'zh-CHT', 'en', 'ar', 'de', 'es', 'fr', 'id', 'it', 'ja', 'ko', 'nl', 'pt', 'ru', 'th', 'vi'];
        if ($lang && in_array($lang,$lan_arr)){
            Cookie::set('yccms_lang',$lang);
            $this->redirect(input('get.yc_url')??'/');
        }
    }


    /**
     * @return bool
     * 移动pc判断
     */
    public function isMobile()
    {
        return request()->isMobile();
    }

    /**
     * 设置变量输出
     * @return void
     */
    private function setVariableOutput(){
        $pid = Random::alnum(10);
        $demo = [
            'name' => '',
            'subheading' => '',
            'createtime' => 1629391614,
            'updatetime' => 1698918642,
            'deletetime' => NULL,
        ];
        $p_info = $demo;
        $c_info = $demo;
        $cid = (int) input('param.cid');
        if (input('param.id')){
            $this->id = (int) input('param.id');
            $this->assign('id',$this->id);
        }
        if ($cid){
            $c_info = yc_recursion_one_data('',[['id','==',$cid]]);
            $this->is_login($c_info);
            $p_in = yc_recursion_one_data('',[['id','==',$c_info['pid']??$pid]]);
            if ($p_in){
                $pid = $p_in['id'];
                $p_info = $p_in;
            }
        }
        $this->assign('cid',$cid);
        $this->assign('pid',$pid);
        $this->assign('c_info',$c_info);
        $this->assign('p_info',$p_info);
    }

    /**
     * 判断登录
     * @return void
     */
    public function is_login($c_info){
        if (!empty($c_info['is_login'])){
            if (!$this->auth->isLogin()){
                $this->redirect('index/user/login');
            }
        }
    }
}