<?php

namespace addons\yccms;

use addons\yccms\library\Translate\platform\Youdao;
use app\common\library\Menu;
use think\Addons;
use think\Config;
use think\Cookie;
use think\Log;

/**
 * 插件
 */
class Yccms extends Addons
{

    /**
     * 插件安装方法
     * @return bool
     */
    public function install()
    {
        $menu = include ADDON_PATH . 'yccms' . DS . 'data' . DS . 'menu.php';
        Menu::create($menu);
        return true;
    }

    /**
     * 插件卸载方法
     * @return bool
     */
    public function uninstall()
    {
        Menu::delete('yccms');
        return true;
    }

    /**
     * 插件启用方法
     * @return bool
     */
    public function enable()
    {
        Menu::enable('yccms');
        return true;
    }

    /**
     * 插件禁用方法
     * @return bool
     */
    public function disable()
    {
        Menu::disable('yccms');
        return true;
    }

    /**
     * 应用初始化
     */
    public function appInit()
    {
        $taglib = Config::get('template.taglib_pre_load');
        Config::set('template.taglib_pre_load', ($taglib ? $taglib . ',' : '') . 'addons\\yccms\\taglib\\Yc');
        include_once $this->addonPath . DS ."common.php";
        cookie('yc_pc_template','pc',3600);
    }


    /**
     * 视图输出过滤标签位
     * @param $content
     * @return bool
     * @throws \Exception
     */
    public function viewFilter(&$content)
    {
        $host  = request()->host();
        //是否翻译
        $yd_stu = yc_get_config('yd_stu');
        $lang = cookie('yccms_lang');
        $lan_arr = ['zh-CHT', 'en', 'ar', 'de', 'es', 'fr', 'id', 'it', 'ja', 'ko', 'nl', 'pt', 'ru', 'th', 'vi'];
        if (!empty($yd_stu) && !empty($lang) && ($lang != 'zh-CHS') && in_array($lang,$lan_arr)){
            $stu = 0;
            $url = request()->url();
            //入口
            $baseFile = request()->baseFile();
            if ($baseFile == "/index.php"){
                //翻译
                $template = cookie('yc_pc_template')??'pc';
                $cache = cache($lang.$template.md5($url));
                if ($cache){
                    $content = $cache;
                }else{
                    $ret = (new Youdao())->ver_request($content,$lang);
                    if (!empty($ret['code'])){
                        $content = $ret['data'];
                        cache($lang.$template.md5($url),$content);
                    }else{
                        Log::notice('有道翻译:'.$ret['msg']);
                    }
                }
                //自定义翻译数据
                $f_url = ADDON_PATH . DS . "yccms". DS ."data". DS ."lang" . DS ."$lang.php";
                if (is_file($f_url)){
                    $zdy_data = include_once $f_url;
                    if (!empty($zdy_data) && is_array($zdy_data)){
                        foreach ($zdy_data as $key => $val){
                            if (strrpos($content, $key)){
                                $content = str_replace($key,$val,$content);
                            }
                        }
                    }
                }
            }
        }
        return true;
    }


}